<?php $__env->startSection('title', 'View Blog Post'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3"><?php echo e($blog->title); ?></h1>
    <div class="d-flex gap-2">
        <a href="<?php echo e(route('admin.blogs.edit', $blog)); ?>" class="btn btn-warning">
            <i class="bi bi-pencil"></i> Edit
        </a>
        <a href="<?php echo e(route('admin.blogs.index')); ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Back to List
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card mb-4">
            <div class="card-body">
                <?php if($blog->featured_image): ?>
                    <img src="<?php echo e(asset('storage/' . $blog->featured_image)); ?>" alt="<?php echo e($blog->title); ?>" class="img-fluid mb-3 rounded">
                <?php endif; ?>
                
                <div class="mb-3">
                    <strong>Excerpt:</strong>
                    <p class="text-muted"><?php echo e($blog->excerpt ?? 'No excerpt provided'); ?></p>
                </div>

                <div class="mb-3">
                    <strong>Content:</strong>
                    <div class="mt-2"><?php echo nl2br(e($blog->content)); ?></div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Post Details</h5>
            </div>
            <div class="card-body">
                <p><strong>Slug:</strong><br><code><?php echo e($blog->slug); ?></code></p>
                <p><strong>Author:</strong><br><?php echo e($blog->author ?? 'Not set'); ?></p>
                <p><strong>Published Date:</strong><br><?php echo e($blog->published_at ? $blog->published_at->format('M d, Y') : 'Not set'); ?></p>
                <p><strong>Status:</strong><br>
                    <span class="badge bg-<?php echo e($blog->is_published ? 'success' : 'secondary'); ?>">
                        <?php echo e($blog->is_published ? 'Published' : 'Draft'); ?>

                    </span>
                </p>
                <p><strong>Views:</strong><br><?php echo e($blog->views); ?></p>
                <p><strong>Sort Order:</strong><br><?php echo e($blog->sort_order); ?></p>
                
                <?php if($blog->meta_title): ?>
                    <hr>
                    <p><strong>SEO Meta Title:</strong><br><?php echo e($blog->meta_title); ?></p>
                <?php endif; ?>
                
                <?php if($blog->meta_description): ?>
                    <p><strong>SEO Meta Description:</strong><br><?php echo e($blog->meta_description); ?></p>
                <?php endif; ?>

                <hr>
                <p><strong>Created:</strong><br><?php echo e($blog->created_at->format('M d, Y h:i A')); ?></p>
                <p><strong>Last Updated:</strong><br><?php echo e($blog->updated_at->format('M d, Y h:i A')); ?></p>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/sumankc/Desktop/ENT Care/resources/views/admin/blogs/show.blade.php ENDPATH**/ ?>